#!/usr/bin/python3
"""
    This program can be used to generate a CNF
    to determine higher dimensional Erdos-Szekeres numbers
    (c) 2022 Manfred Scheucher <scheucher@math.tu-berlin.de>
"""


from itertools import *
from sys import *


empty = int(argv[1]) # 0 if k-gon, 1 if k-hole
k = int(argv[2]) # size of gon/hole
d = int(argv[3]) # dimension
n = int(argv[4]) # number of points

r = d+1 # rank of oriented matroid = dimension + 1
N = range(n)

assert(empty in [0,1])

all_variables = []
all_variables += [('chi',I) for I in permutations(N,r)]
all_variables += [('I_sep_pq',(I[:r-1],I[r-1],I[r])) for I in permutations(N,r+1)] # hyperplane determined by I separates the two points p and q
all_variables += [('I_cont_p',(I[:r],I[r])) for I in permutations(N,r+1)] # simplex determined by I contains the point p

all_variables_index = {}

num_vars = 0
for v in all_variables:
    all_variables_index[v] = num_vars
    num_vars += 1

def var(L): return 1+all_variables_index[L]
def var_chi(*L): return var(('chi',L))
def var_hyperplane_separates_2points(*L): return var(('I_sep_pq',L))
def var_simplex_contains_point(*L): return var(('I_cont_p',L)) 

 

f = open(argv[5])

sol = set()
for l in f.readlines():
    if l[0] != 'v': continue
    for x in l.split()[1:]:
        sol.add(int(x))
        


chi = {}
for I in permutations(N,r):
    if var_chi(*I) in sol:
        chi[I] = "+"
    else:
        assert(-var_chi(*I) in sol)
        chi[I] = "-"
print(chi)
